#include <iostream>
#include <vector>
#include <string>
#include <stdio.h>
#include <stdlib.h>
#include "driver.h"
#include "defs.h"
#include "piece.h"
#include "attack.h"
#include "book.h"
#include "log.h"
#include "engine.h"
#include "bits.h"
#include "testers.h"

using namespace std;

const uint modeEPD = 1;
const uint modeBOOKMAKE = 2;
const uint modeCHESSENGINE = 4;
const uint modeBENCH = 8;
const uint modeMIRROR = 16;
const uint modeREGRESS = 32;
void drivebookmake(const vector<string> &args)
{
    string sw;
    uint size = args.size();
    cBookmake makebookobj;
    for(uint i = 0; i < size; ++i)
    {
        sw = args[i];
        if (sw=="-c")
        {
            if(i < size)
            makebookobj.bookoptions.countmoves = atoi(args[i+1].c_str());
            else
            makebookobj.bookoptions.countmoves = 1;
        }
        else if (sw=="-a")
        {
            makebookobj.bookoptions.addtobook = 1;
            cout<<"\n seen add to book option ";
        }
        else if (sw=="-d")
        {
            if(i < size)
            makebookobj.bookoptions.plydepth = atoi(args[i+1].c_str());
            else
            makebookobj.bookoptions.plydepth = 20;//default 20 moves;
        }
        else if (sw=="-p")
        {
            if(i < size)
            makebookobj.bookoptions.pgnfile = args[i+1];
        }
        else if (sw=="-o")
        {
            if(i < size)
            {
                makebookobj.bookoptions.outfile = args[i+1];
                makebookobj.bookoptions.setout=1;
            }
        }
        else if (sw=="-e")
        {
            if(i < size)
            {
                makebookobj.bookoptions.existingbook = args[i+1];
                makebookobj.bookoptions.setexist=1;
                cout<<"\n seen existing book option "<<makebookobj.bookoptions.existingbook;
            }
        }
    }

    makebookobj.readpgn();
}

void driveepd(const vector<string> &args)
{
    ;
}

void drivetester(const int mode, const vector<string> &args)
{
    cTester process;
    string sw;
    uint size = args.size();

    process.depthset = 0;//default time limited ie depth 0
    process.timeperposition = 0;
    process.tree.opt->special = true;

    for(uint i = 0; i < size; ++i)
    {
        sw = args[i];
        if (sw=="-t")
        {
            if(i < size)
            process.timeperposition = atoi(args[i+1].c_str())*1000;
        }
        else if (sw=="-i")
        {
            if(i < size)
            process.inputfilename = args[i+1];
        }
        else if (sw=="-o")
        {
            if(i < size)
            process.outputfilename = args[i+1];
        }
        else if (sw=="-d")
        {
            if(i < size)
            {
             process.depthset = atoi(args[i+1].c_str());
            }
        }
        else if (sw=="-ini")
        {
            if(i < size)
            process.tree.opt->inifilename = args[i+1];
        }
    }

    if(process.depthset!=0 && process.timeperposition != 0)
    {
        cout<<"\n ERROR - both time and depth set exiting";
        return;
    }
#ifdef DEBUG
            cout << "ini file set to "<<process.tree.opt->inifilename<<endl;
            if(logger.islog()) logger.file << "ini file set to "<<process.tree.opt->inifilename<<endl;
#endif
    //crucial init
    process.tree.readini(process.tree.opt->inifilename);

    if(mode==modeMIRROR)
    process.evalmirror();
    else if(mode==modeBENCH)
    process.benchmark();
    else if(mode==modeREGRESS)
    process.regress();
    else if(mode==modeEPD)
    process.epdtest();
    return;
}

void driveengine(const vector<string> &args)
{

   setbuf(stdout, NULL);
   setbuf(stdin, NULL);
   setvbuf(stdout, NULL, _IONBF, 0);
   setvbuf(stdin, NULL, _IONBF, 0);
   char command[512];
   cEngine process;

    string sw;
    uint size = args.size();

    for(uint i = 0; i < size; ++i)
    {
        sw = args[i];
        if (sw=="-ini")
        {
            if(i < size)
            process.tree.opt->inifilename = args[i+1];
        }
    }

#ifdef DEBUG
            cout << "ini file set to "<<process.tree.opt->inifilename<<endl;
            if(logger.islog()) logger.file << "ini file set to "<<process.tree.opt->inifilename<<endl;
#endif

   //crucial init
    process.tree.readini(process.tree.opt->inifilename);
    process.tree.opt->special = false;

   for (;;)
    {
        cin>>command;
        if (!strcmp(command, "uci")) {process.process_uci();return;}
        if (!strcmp(command, "xboard")) {process.process_xboard(); return;}
        else if(!strcmp(command, "quit")) return;
        else cout<<"\nunknown command <"<<command<<"> use 'uci' or 'xboard' or 'quit'";
    }

    return;
}

void start_driver(const int argc, char* argv[])
{
    init_piece_matrices();
    init_attack_tables();
    init_bitboards();
    logger.setlog(false);

    vector<string> mainargs;
    int argument = 1;
    while (argument < argc)
    {
        mainargs.push_back(argv[argument]);
        argument++;
    }
#ifdef DEBUG
    cout<<"\n total args "<<mainargs.size()<<endl;
#endif
    uint mode = 0;
    for(uint i = 0; i< mainargs.size(); ++i)
    {
        if(mainargs[i]=="-bookmake")
        mode = modeBOOKMAKE;
        else if(mainargs[i]=="-epd")
        mode = modeEPD;
        else if(mainargs[i]=="-bench")
        mode = modeBENCH;
        else if(mainargs[i]=="-mirror")
        mode = modeMIRROR;
        else if(mainargs[i]=="-regress")
        mode = modeREGRESS;
    }

    if(!mode) mode = modeCHESSENGINE;
    if(mode == modeBOOKMAKE)  drivebookmake(mainargs);
    else if(mode == modeCHESSENGINE)  driveengine(mainargs);
    else if(mode == modeBENCH || mode == modeMIRROR || mode == modeREGRESS || mode == modeEPD)  drivetester(mode,mainargs);

    return;

}
